/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Base64;

public class FileUtil {
    public static String extension(String filename) {
        if (filename == null) {
            return null;
        }
        int l = filename.lastIndexOf(46);
        if (l == -1) {
            return null;
        }
        String p = filename.substring(l + 1).toLowerCase();
        if (p.length() == 0) {
            return null;
        }
        return p;
    }

    public static String normalizePath(String p) {
        if (p == null) {
            return "";
        }
        p = p.replaceAll("\\\\", "/");
        p = p.replaceAll("(\\/\\.+)", "");
        p = p.replaceAll("[^A-Za-z0-9\\/\\.\\-_ @]", "");
        return p;
    }

    public static String basename(String f) {
        int p = f.lastIndexOf(47);
        if (p != -1) {
            f = f.substring(p + 1);
        }
        if ((p = f.lastIndexOf(92)) != -1) {
            f = f.substring(p + 1);
        }
        return f;
    }

    public static String normalizedBasename(String f) {
        return FileUtil.normalizePath(FileUtil.basename(f));
    }

    public static Integer inputStream2File(InputStream is, String f) throws IOException {
        return FileUtil.inputStream2File(is, new File(f));
    }

    public static Integer inputStream2File(InputStream is, File f) throws IOException {
        int len;
        int r = 0;
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
        byte[] buf = new byte[4096];
        while ((len = bis.read(buf)) != -1) {
            ((OutputStream)bos).write(buf, 0, len);
            r += len;
        }
        bis.close();
        ((OutputStream)bos).close();
        return r;
    }

    public static Integer file2outputstream(File f, OutputStream os) throws IOException {
        int len;
        int r = 0;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] buf = new byte[4096];
        while ((len = bis.read(buf)) != -1) {
            ((OutputStream)bos).write(buf, 0, len);
            r += len;
        }
        bis.close();
        ((OutputStream)bos).close();
        return r;
    }

    public static String file2string(File f) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        byte[] bytes = is.readAllBytes();
        ((InputStream)is).close();
        return new String(bytes);
    }

    public static String file2base64(File f) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        byte[] bytes = is.readAllBytes();
        ((InputStream)is).close();
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String file2base64(String f) throws IOException {
        return FileUtil.file2base64(new File(f));
    }

    public static String file2string(String path) throws IOException {
        return FileUtil.file2string(new File(path));
    }

    public static String file2string(String path, String defaultVal) {
        File f = new File(path);
        if (!f.exists()) {
            return defaultVal;
        }
        try {
            return FileUtil.file2string(f);
        }
        catch (IOException e) {
            return defaultVal;
        }
    }

    public static void string2file(String output, File f) throws IOException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(f));
        pw.write(output);
        pw.close();
    }

    public static void string2file(String output, String file) throws IOException {
        File f = new File(file);
        PrintWriter pw = new PrintWriter(new FileOutputStream(f));
        pw.write(output);
        pw.close();
    }

    public static void byte2file(byte[] data, File f) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        os.write(data);
        os.close();
    }

    public static void byte2file(byte[] data, String f) throws IOException {
        FileUtil.byte2file(data, new File(f));
    }

    public static void char2file(char[] data, File f) throws IOException {
        OutputStreamWriter os = new OutputStreamWriter(new FileOutputStream(f));
        os.write(data);
        os.close();
    }

    public static void char2file(char[] data, String f) throws IOException {
        FileUtil.char2file(data, new File(f));
    }

    public static Integer copy(InputStream is, OutputStream os) throws IOException {
        int len;
        int r = 0;
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buf = new byte[4096];
        while ((len = bis.read(buf)) != -1) {
            os.write(buf, 0, len);
            r += len;
        }
        return r;
    }

    public static Integer copy(InputStream is, PrintWriter pw) throws IOException {
        int len;
        int r = 0;
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buf = new byte[4096];
        while ((len = bis.read(buf)) != -1) {
            pw.write(new String(buf), 0, len);
            r += len;
        }
        return r;
    }

    public static void main(String[] args) {
        try {
            System.out.println("Test: " + Base64.getEncoder().encodeToString("blabla lets fff... goooo!!".getBytes()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

